<?php
class JeeRemiCmd extends cmd {
    public function execute($_options = array()) {
        $eq = $this->getEqLogic();
        $logical = $this->getLogicalId();
        $api = new RemiAPI($eq);
        if (strpos($logical,'remi_light_')===0) {
            $parts = explode('_',$logical);
            $id = $parts[2]; $action = $parts[3];
            if ($action=='on') return $api->call_action($id,'turn_on',array());
            if ($action=='off') return $api->call_action($id,'turn_off',array());
            if ($action=='brightness') {
                $level = isset($_options['slider'])?intval($_options['slider']): (isset($_options['payload'])?intval($_options['payload']):null);
                if ($level===null) throw new Exception('Missing brightness');
                return $api->call_action($id,'set_brightness',array('value'=>$level));
            }
        }
        if (strpos($logical,'remi_')===0) {
            $id = substr($logical,5);
            $payload = isset($_options['payload'])?$_options['payload']:null;
            return $api->set_device_state($id,$payload);
        }
        throw new Exception('Unknown command');
    }
}
?>