<?php
require_once dirname(__FILE__).'/../../3rdparty/remiapi.class.php';

class JeeRemi extends eqLogic {
    public static $_originalClass = __CLASS__;

    public static function syncFromCloud($eq) {
        try {
            $api = new RemiAPI($eq);
            $devices = $api->list_devices();
            if (!is_array($devices)) return array('status'=>'no_devices');
            $existing = array();
            foreach($eq->getCmd() as $c) {
                // capture device logical IDs (remi_ or remi_light_...)
                $lid = $c->getLogicalId();
                if (strpos($lid,'remi_')===0) $existing[$lid] = $c;
            }
            $created = 0; $updated = 0; $deleted = 0;
            $foundLogical = array();
            foreach($devices as $d) {
                $id = isset($d['id']) ? $d['id'] : (isset($d['device_id']) ? $d['device_id'] : null);
                if (!$id) continue;
                $logical = 'remi_'.$id;
                $foundLogical[] = $logical;
                $cmd = $eq->getCmd(null, $logical);
                if (!is_object($cmd)) {
                    $cmd = new jeeremiCmd();
                    $cmd->setEqLogic_id($eq->getId());
                    $cmd->setLogicalId($logical);
                    $cmd->setName(isset($d['name'])?$d['name']:'Remi '.$id);
                    $cmd->setType('info');
                    $cmd->setSubType('string');
                    $cmd->save();
                    $created++;
                } else {
                    $updated++;
                }
                $cmd->event(json_encode($d));
            }
            // delete commands not present anymore
            foreach($existing as $lid=>$c) {
                if (!in_array($lid,$foundLogical)) {
                    $c->remove();
                    $deleted++;
                }
            }
            return array('status'=>'ok','created'=>$created,'updated'=>$updated,'deleted'=>$deleted);
        } catch(Exception $e) {
            return array('status'=>'error','message'=>$e->getMessage());
        }
    }

    public function preSave() {
        if ($this->getConfiguration('host') == '') $this->setConfiguration('host','https://api.urbanhello.com');
    }
}
?>