<?php
require_once dirname(__FILE__).'/../../../../core/php/core.inc.php';
if (!isConnect()) throw new Exception('401');
$action = init('action');
switch($action) {
    case 'listDevices':
        $eqId = init('id');
        $eq = eqLogic::byId($eqId);
        $api = new RemiAPI($eq);
        ajax::success($api->list_devices());
    break;
    case 'syncDevices':
        $eqId = init('id');
        $eq = eqLogic::byId($eqId);
        $res = JeeRemi::syncFromCloud($eq);
        ajax::success($res);
    break;
    case 'testAuth':
        $eqId = init('id');
        $eq = eqLogic::byId($eqId);
        $base = init('base'); $email = init('email'); $password = init('password');
        $eq->setConfiguration('base_url',$base);
        $eq->setConfiguration('email',$email);
        $eq->setConfiguration('password',$password);
        $eq->save();
        try {
            $api = new RemiAPI($eq);
            $t = $api->login();
            ajax::success(array('status'=>'ok','token'=>$t));
        } catch(Exception $e) {
            ajax::success(array('status'=>'error','message'=>$e->getMessage()));
        }
    break;
    default:
        throw new Exception('Unknown action');
}
?>