<?php
/* remiapi.class.php - generated from original api.py (excerpt)
import aiohttp
import logging

_LOGGER = logging.getLogger(__name__)


class RemiAPI:
    BASE_URL = "https://remi2.urbanhello.com/parse"

    def __init__(self, username, password):
        self.username = username
        self.password = password
        self.session_token = None
        self.remis = []
        self.cache = {}  # Stocke les données pour chaque Remi
        self.cache_expiry = {}  # Stocke l'heure d'expiration du cache
        self.cache_duration = 60  # Durée de vie du cache en secondes
        self.faces = {}  # Stocke les faces disponibles par nom

    async def login(self):
        """Authenticate with the Rémi API and retrieve available devices."""
        url = f"{self.BASE_URL}/login"
        payload = {"username": self.username, "password": self.password}
        headers = {
            "x-parse-application-id": "jf1a0bADt5fq",
            "content-type": "application/json",
        }

        async with aiohttp.ClientSession() as session:
            async with session.post(url, json=payload, headers=headers) as response:
                if response.status != 200:
                    raise Exception(f"Login failed: {response.status}")
                data = await response.json()
                self.session_token = data["sessionToken"]
                self.remis = data.get("remis", [])
                _LOGGER.debug("Login successful, devices available: %s", self.remis)
                # Récupérer les faces après le login
                await self.get_faces()
                return data

    async def get_faces(self):
        """Retrieve available faces and their objectId."""
        url = f"{self.BASE_URL}/classes/Face"
        headers = {
            "x-parse-session-token": self.session_token,
            "x-parse-application-id": "jf1a0bADt5fq",
            "content-type": "application/json",
        }
        payload = {"order": "index", "_method": "GET"}

        async with aiohttp.ClientSession() as session:
            async with s
...
*/
class RemiAPI {
    private $_eq;
    private $_base;
    private $_email;
    private $_password;
    private $_token;
    private $_headers = array();

    public function __construct($eqLogic) {
        $this->_eq = $eqLogic;
        $this->_base = rtrim($eqLogic->getConfiguration('base_url','https://api.urbanhello.com'), '/');
        $this->_email = $eqLogic->getConfiguration('email','');
        $this->_password = $eqLogic->getConfiguration('password','');
        $this->_token = $eqLogic->getConfiguration('token','');
        if ($this->_token) $this->_headers[] = 'Authorization: Bearer '.$this->_token;
    }

    private function http($path, $method='GET', $data=null) {
        $url = $this->_base . $path;
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        $headers = array('Accept: application/json','Content-Type: application/json');
        foreach($this->_headers as $h) $headers[] = $h;
        if ($data !== null) { curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data)); }
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $res = curl_exec($ch);
        $err = curl_error($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($res === false) throw new Exception('HTTP request failed: '.$err);
        $decoded = json_decode($res, true);
        if ($code >= 400) throw new Exception('API error: '.$code.' '.var_export($decoded, true));
        return $decoded;
    }

    public function login() {
        if (!empty($this->_token)) return $this->_token;
        if (empty($this->_email) || empty($this->_password)) throw new Exception('Email/password not configured');
        // POST /auth/login or similar - adapted from HA api.py
        $data = array('email'=>$this->_email,'password'=>$this->_password);
        $res = $this->http('/auth/login','POST',$data);
        if (isset($res['access_token'])) { $this->_token = $res['access_token']; $this->_headers[] = 'Authorization: Bearer '.$this->_token; return $this->_token; }
        if (isset($res['token'])) { $this->_token = $res['token']; $this->_headers[] = 'Authorization: Bearer '.$this->_token; return $this->_token; }
        // store token in eq configuration
        if ($this->_token) {
            $this->_eq->setConfiguration('token',$this->_token);
            $this->_eq->save();
        }
        throw new Exception('Login failed');
    }

    public function list_devices() {
        $this->login();
        // Try multiple endpoints as HA integration may use /devices or /api/devices
        $try = array('/api/devices','/devices','/api/v2/devices','/tiles');
        foreach($try as $p) {
            try { $res = $this->http($p,'GET',null); if (is_array($res)) return $res; } catch(Exception $e) { /* continue */ }
        }
        throw new Exception('No devices endpoint reachable');
    }

    public function get_device($id) {
        $this->login();
        return $this->http('/api/devices/'.rawurlencode($id),'GET',null);
    }

    public function call_action($id,$action,$params=array()) {
        $this->login();
        return $this->http('/api/devices/'.rawurlencode($id).'/action','POST',array_merge(array('action'=>$action),$params));
    }

    public function set_device_state($id, $state) {
        $this->login();
        return $this->http('/api/devices/'.rawurlencode($id).'/state','POST', array('state'=>$state));
    }
}
?>